//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#define def_VERSION_DEBUG
//+------------------------------------------------------------------+
#ifdef def_VERSION_DEBUG
	#define macro_DEBUG_MODE(A) \
					Print(__FILE__, " ", __LINE__, " ", __FUNCTION__ + " " + #A + " = " + (string)(A));
#else
	#define macro_DEBUG_MODE(A)
#endif
//+------------------------------------------------------------------+
#define def_SymbolReplay			"RePlay"
#define def_MaxPosSlider 			400
#define def_MaskTimeService		0xFED00000
#define def_IndicatorTimeFrame	(_Period < 60 ? _Period : (_Period < PERIOD_D1 ? _Period - 16325 : (_Period == PERIOD_D1 ? 84 : (_Period == PERIOD_W1 ? 91 : 96))))
#define def_IndexTimeFrame			4
//+------------------------------------------------------------------+
union uCast_Double
{
	double 	dValue;
	long		_long;											// 1 Information
	datetime _datetime;										// 1 Information
	uint		_32b[sizeof(double) / sizeof(uint)];	//	2 Informations
	ushort	_16b[sizeof(double) / sizeof(ushort)];	// 4 Informations
	uchar		_8b [sizeof(double) / sizeof(uchar)];	// 8 Informations
};
//+------------------------------------------------------------------+
enum EnumEvents 	{
			evHideMouse,					//Hide mouse price line
			evShowMouse,					//Show mouse price line
			evHideBarTime,					//Hide bar time
			evShowBarTime,					//Show bar time
			evHideDailyVar,				//Hide daily variation
			evShowDailyVar,				//Show daily variation
			evHidePriceVar,				//Hide instantaneous variation
			evShowPriceVar,				//Show instantaneous variation
			evCtrlReplayInit,				//Initialize replay control
			evChartTradeBuy,				//Market buy event
			evChartTradeSell,				//Market sales event 
			evChartTradeCloseAll			//Event to close positions
						};
//+------------------------------------------------------------------+